#version 120

precision highp float;
#define MAX_LIGHTS 14
uniform float testvalue;

in vec3 alightVec[MAX_LIGHTS];

in vec2 texCoord;

in vec3 v;
in vec3 N;
in vec3 T;
in vec3 B;

uniform vec4 flash;
uniform vec4 glColor;
uniform vec3 camPos;

uniform float lightsPosx[MAX_LIGHTS];
uniform float lightsPosy[MAX_LIGHTS];
uniform float lightsPosz[MAX_LIGHTS];



uniform float lightsEnabled[MAX_LIGHTS];
uniform float lightsinvRadius[MAX_LIGHTS];
uniform float lightMapSelect[MAX_LIGHTS];


uniform float lightsAmbientr[MAX_LIGHTS];
uniform float lightsAmbientg[MAX_LIGHTS];
uniform float lightsAmbientb[MAX_LIGHTS];

uniform float lightsDiffuser[MAX_LIGHTS];
uniform float lightsDiffuseg[MAX_LIGHTS];
uniform float lightsDiffuseb[MAX_LIGHTS];

uniform float lightsSpecularr[MAX_LIGHTS];
uniform float lightsSpecularg[MAX_LIGHTS];
uniform float lightsSpecularb[MAX_LIGHTS];



uniform sampler2D colorMap;
uniform sampler2D normalMap;
uniform sampler2D lightMap;
uniform sampler2D specularMap;


vec3 CalcBumpedNormal()
{
    

    vec3 Normal = N;
    vec3 Tangent = T;
    Tangent = normalize(Tangent - dot(Tangent, Normal) * Normal);
    
    vec3 Bitangent = B;
    
    vec3 BumpMapNormal = vec3(0.5,0.5,1.0);
    BumpMapNormal = 2.0 * BumpMapNormal - vec3(1.0, 1.0, 1.0);
    vec3 NewNormal;
    mat3 TBN = mat3(Tangent, Bitangent, Normal);
    NewNormal = TBN * BumpMapNormal;
    NewNormal = normalize(NewNormal);
    return NewNormal;
}

void main (void)
{
    vec3 lightVec;
    vec3 eyeVec;
    vec4 accvDiffuse = vec4(0.0);
    vec4 accvSpecular = vec4(0.0);
    float distSqr;
    vec3 lVec;
    vec3 vVec;
    float att;
    vec4 base;
    vec4 vAmbient;
    vec3 bump;
    float diffuse;
    vec4 vDiffuse;
    vec4 vSpecular;
    float specular;
    vec3 nrmltexture;

    base = texture2D(colorMap, texCoord);
    
    vAmbient = vec4(1.0f,1.0f,1.0f,1.0f)
               * vec4(lightsAmbientr[0],lightsAmbientg[0],lightsAmbientb[0],1.0f);
    

    vec3 viewDir = normalize(camPos-v);

    for (int i=0; i<MAX_LIGHTS; i++)
    
    {
        if (lightsEnabled[i]>0.0)
        {
            vec3 L = normalize(vec3(lightsPosx[i],lightsPosy[i],lightsPosz[i]) - v);
            vec3 E = normalize(-v); 
            vec3 R = normalize(-reflect(L,N));
            vec3 lightDir = L;

            lightVec=alightVec[i];
            
            lightVec=L; eyeVec=E; 

            distSqr = dot(lightVec, lightVec);
            float factor=10.0f;
            att = clamp(1.0 - (lightsinvRadius[i]) * sqrt(distSqr), 0.0, 1.0)/factor;


            
            lVec = lightVec * inversesqrt(distSqr);
            

            
            
            bump=CalcBumpedNormal();

            
            diffuse = clamp( dot(lVec, bump), 0.0, 1.0 );
            
            vDiffuse = vec4(lightsDiffuser[i],lightsDiffuseg[i],lightsDiffuseb[i],1.0f) * diffuse;
                       

            
            
            diffuse = max(dot(bump,L), 0.0);
            vec4 Idiff = vec4 (lightsDiffuser[i],lightsDiffuseg[i],lightsDiffuseb[i],1.0f) * diffuse;
                        
            Idiff = clamp(Idiff, 0.0, 1.0);

            accvDiffuse = accvDiffuse + Idiff *att;
            

            
            
            

            
            


            vec3 reflectDir=reflect(-lightDir,bump);
            const float shininess=1.5f;
            
            specular = pow(clamp(dot(viewDir,reflectDir)*shininess,0.0f,1.0f),1.2f); 
            
            
            

            

            vSpecular = vec4(lightsSpecularr[i],lightsSpecularg[i],lightsSpecularb[i],1.0f)* specular;
                        


            
            
            
            
            
            vec4 Ispec = vec4(lightsSpecularr[i],lightsSpecularg[i],lightsSpecularb[i],1.0f) * specular;
                        
            
            
            
            Ispec = clamp(Ispec, 0.0, 1.0);

            
            accvSpecular = accvSpecular + Ispec * att;

            
            
        }
    }
    
    
    gl_FragColor = ( vAmbient + accvDiffuse + accvSpecular)*glColor;
    
    
    
    
    
    
    
    
    
    
    

    

    
    
    
}











